<?php
/**
 * Settings Links
 * Defines plugin settings links on the plugin page.
 *
 * @category Base
 * @package  OxyProps
 * @author   Cédric Bontems <cedric@thewebforge.dev>
 * @license  https://www.gnu.org/licenses/gpl-2.0.html  GPL v2 or later
 * @link     https://oxyprops.com                       OxyProps Website
 * @since    1.0.0
 */

namespace OxyProps\Inc;

/**
 * Settings Links Class
 * Defines plugin settings links on the plugin page.
 *
 * @author   Cédric Bontems <cedric@thewebforge.dev>
 * @since    1.0.0
 */
class Settings_Links extends Base_Controller {

	/**
	 * Stores the Settings Links Singleton.
	 *
	 * @var object
	 *
	 * @since  1.0.0
	 * @author Cédric Bontems <cedric@thewebforge.dev>
	 */
	private static $instance;

	/**
	 * Returns the Settings Links Singleton.
	 *
	 * @return object Instance
	 *
	 * @since  1.0.0
	 * @author Cédric Bontems <cedric@thewebforge.dev>
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new Settings_Links();
		}

		return self::$instance;
	}

	/**
	 * Initializes the Settings Links Class
	 *
	 * @return void
	 *
	 * @since  1.0.0
	 * @author Cédric Bontems <cedric@thewebforge.dev>
	 */
	public function register() {
		add_filter( "plugin_action_links_{$this->oxyprops_plugin}", array( $this, 'settings_links' ) );
	}

	/**
	 * Adds links to the plugins page.
	 *
	 * @param array $links array of plugin links.
	 *
	 * @return array
	 *
	 * @since  1.0.0
	 * @author Cédric Bontems <cedric@thewebforge.dev>
	 *
	 * TODO: Select the relevant links once version is ready.
	 */
	public function settings_links( $links ) {
		$links[] = '<a href="' . esc_url( admin_url( 'admin.php?page=oxyprops' ) ) . '">' . esc_html__( 'Settings', 'oxyprops' ) . '</a>';
		$links[] = '<a target="_blank" href="https://docs.oxyprops.com" >' . esc_html__( 'Docs', 'oxyprops' ) . '</a>';

		return $links;
	}
}
